﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;
using Soneta.Kadry.UI.KadryNet.ViewInfo.PanelKierownika;
using Soneta.Langs;

namespace ASP {
    
    public partial class Badania_Okresowe : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_Definicja = "(razem)";
        public string Str_OkresAll = "(wszystko)";

        public class PrnParams: ContextBase {
    
            public PrnParams(Context context): base(context) {
                okres = GetOkres();
            }
    
            TypZakresu zakres = TypZakresu.Planowane;
            [Caption("Zakres")]
            [Priority(10)]
            [DefaultWidth(19)]
            public TypZakresu Zakres {
                get { return zakres; }
                set {
                    zakres  = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            DefinicjaBadaniaLekarskiego definicja;
            [Caption("Definicja")]
            [Priority(20)]
            public DefinicjaBadaniaLekarskiego Definicja {
                get { return definicja; }
                set {
                    definicja = value;
                    OnChanged(EventArgs.Empty);
                }
            }
    
            FromTo okres;
		    [Soneta.Business.Required]
            [Caption("Raport za okres")]
            [Priority(30)]
            public FromTo Okres {
                get { return okres; }
                set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }

		    public object GetListDefinicja() {
                KadryModule kadry = KadryModule.GetInstance(this);
                Soneta.Business.View v = kadry.DefBadanLek.WgNazwy.CreateView();
                v.Condition &= new FieldCondition.NotEqual("Blokada", true);
                return v;
		    }
		
            FromTo GetOkres() {
                return new YearMonth(ActualDate.Today(Context)).ToFromTo();
            }
        }
    
        PrnParams pars = null;
        [Context(Required=true)]
        public PrnParams Params {
            set { pars = value; }
        }

        RowCondition condition = RowCondition.Empty;

        protected void OnContextLoad(Object sender, EventArgs args) {
		    // Odczytanie listy pracowników podległych z kontekstu
		    // Metoda znajduje się we wspólnej klasie dla strony raportu
		    // Soneta.Web.UI.ReportCorePage
            Row[] rows = getRows();

            ReportHeader1["DEFINICJA"] = pars.Definicja != null ? pars.Definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo)) : Str_Definicja;
            ReportHeader1["OKRES"] = (pars.Okres != FromTo.All) ? pars.Okres.ToString() : Str_OkresAll;
            ReportHeader1["ZAKRES"] = CaptionAttribute.EnumToString(pars.Zakres, new System.Globalization.CultureInfo(Str_CultureInfo));

            if (pars.Definicja != null)
                condition &= new FieldCondition.In("Definicja", pars.Definicja);

            if (pars.Okres != FromTo.All)
                switch (pars.Zakres) {
                    case TypZakresu.Planowane:
                        condition &= new FieldCondition.Contain("Termin", pars.Okres);
                        break;
                    case TypZakresu.Aktualne:
                        condition &= (new FieldCondition.LessEqual("Data", pars.Okres.To) &
                            new FieldCondition.NotEqual("Data", Date.Empty));
                        condition &= (new FieldCondition.GreaterEqual("NastępneTermin", pars.Okres.From) |
                            new FieldCondition.Null("NastępneTermin", true));
                        break;
                    case TypZakresu.Odbyte:
                        condition &= new FieldCondition.Contain("Data", pars.Okres);
                        break;
                }

            Grid1.DataSource = rows;

            if (pars.Definicja != null) {
                colPrac.Width += colNazwa.Width;
                colNazwa.Visible = false;
            }
        }

        protected void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
            Pracownik prac = (Pracownik)args.Row;

            var v = KadryModule.GetInstance(prac).BadaniaLekarskie.WgDaty.CreateView();
            v.Condition &= new FieldCondition.Equal("Pracownik", prac);
            v.Condition &= condition;

            bool any = false;

            foreach (BadanieLekarskie bl in v) {
                any = true;
                colNazwa.AddLine(bl.Definicja.GetLocalizedNazwa(new System.Globalization.CultureInfo(Str_CultureInfo)));
                colTermin.AddLine(bl.Termin);
                colData.AddLine(bl.Data != Date.Empty ? bl.Data.ToString() : "&nbsp;");
                colOpis.AddLine(bl.Opis.ToString() != "" ? bl.Opis.ToString() : "&nbsp;");
            }

            args.VisibleRow = any;
        }

        private Row[] getRows() {
            //Soneta.Business.View v = Soneta.Web.Business.Kadry.Tools.GetPodwładni(dc);
            var podwladni = KadryModule.GetInstance(dc.Context).Pracownicy.CreateView();
            Soneta.KadryPlace.Kadry.KalkulatorPodwladnych kalkulator = new Soneta.KadryPlace.Kadry.KalkulatorPodwladnych(dc.Context.Session, dc.Context.Session.Login.WebUserInstance.Host.ID);
            podwladni.Condition &= kalkulator.FiltrPodległości(pars.Okres, false);
            List<Pracownik> list = new List<Pracownik>();
            foreach (Pracownik p in podwladni)
                list.Add(p);
            return list.ToArray();
        }
    }
}
